UI.Label("Tools")
UI.Separator()
-- UI do painel superior com botão de editar
local ui = setupUI([[
Panel
  height: 19

  BotSwitch
    id: title
    anchors.top: parent.top
    anchors.left: parent.left
    text-align: center
    width: 130
    !text: tr('Loot Seller')

  Button
    id: edit
    anchors.top: prev.top
    anchors.left: prev.right
    anchors.right: parent.right
    margin-left: 3
    height: 17
    text: Edit
]])

-- UI do painel de edição
local edit = setupUI([[
Panel
  height: 105

  Label
    anchors.top: parent.top
    anchors.left: parent.left
    anchors.right: parent.right
    margin-top: 5
    text-align: center
    text: Loots a vender:

  BotContainer
    id: LootItems
    anchors.top: prev.bottom
    anchors.left: parent.left
    anchors.right: parent.right
    height: 100
]])
edit:hide()

-- Configuração inicial
if not storage.lootSeller then
    storage.lootSeller = {
        enabled = false,
        lootItems = {}
    }
end

local config = storage.lootSeller
local showEdit = false

-- Botão de abrir/fechar o editor
ui.edit.onClick = function()
    showEdit = not showEdit
    if showEdit then
        edit:show()
    else
        edit:hide()
    end
end

-- Alternador liga/desliga
ui.title:setOn(config.enabled)
ui.title.onClick = function()
    config.enabled = not config.enabled
    ui.title:setOn(config.enabled)
end

-- Container interativo
UI.Container(function()
    config.lootItems = edit.LootItems:getItems()
end, true, nil, edit.LootItems)
edit.LootItems:setItems(config.lootItems)

-- Helper para extrair IDs
local function getItemIds(list)
    local ids = {}
    for _, entry in pairs(list) do
        table.insert(ids, entry.id)
    end
    return ids
end

macro(500, "", function()
    if not config.enabled then return end

    local itemDeVenda = findItem(19455)
    if not itemDeVenda then return end

    local ids = getItemIds(config.lootItems)

    local foundLootItem = nil
    for _, lootId in ipairs(ids) do
        local lootItem = findItem(lootId)
        if lootItem then
            foundLootItem = lootItem
            break
        end
    end

    if foundLootItem then
        g_game.useWith(itemDeVenda, foundLootItem)
    end
end)

